% walker_lang.m
% Darren Chang (darrenz@mit.edu)
% last modified: 11/26/02
% A function that calculates the optimized Walker constellation
% Based on information supplied by Dr. Thomas Lang

function [Tmin,Pmin,Fmin,Imin] = walker_lang(theta,diversity)

T =	[5	6	6	6	7	8	8	8	9	9	10	10	10	11	12	12	12	12	12	13	14	14	14	15	15	15	16	16	16	16	17	18	18	18	18	18	19	20	20	20	20	20	21	21	21	22	22	22	23	24	24	24	24	24	24	24	25	25	26	26	26	27	27	27	28	28	28	28	28	29	30	30	30	30	30	30	30	31	32	32	32	32	32	33	33	33	34	34	34	35	35	35	36	36	36	36	36	36	36	36	37	38	38	38	39	39	39	40	40	40	40	40	40	40	41	42	42	42	42	42	42	42	43	44	44	44	44	44	45	45	45	45	45	46	46	46	47	48	48	48	48	48	48	48	48	48	49	49	50	50	50	50	50	51	51	51	52	52	52	52	52	53	54	54	54	54	54	54	54	55	55	55	56	56	56	56	56	56	56	57	57	57	58	58	58	59	60	60	60,...
	60	60	60	60	60	60	60	60	61	62	62	62	63	63	63	63	63	64	64	64	64	64	64	65	65	65	66	66	66	66	66	66	66	67	68	68	68	68	68	69	69	69	70	70	70	70	70	70	70	71	72	72	72	72	72	72	72	72	72	72	72	73	74	74	74	75	75	75	75	75	76	76	76	76	76	77	77	77	78	78	78	78	78	78	78	79	80	80	80	80	80	80	80	80	80	81	81	81	81	82	82	82	83	84	84	84	84	84	84	84	84	84	84	84	85	85	85	86	86	86	87	87	87	88	88	88	88	88	88	88	89	90	90	90	90	90	90	90	90	90	90	90	91	91	91	92	92	92	92	92	93	93	93	94	94	94	95	95	95	96	96	96	96	96	96	96	96	96	96	96	97	98	98	98	98	98	99	99	99	99	99	100	100	100	100	100	100	100	100];
P =	[5	2	3	6	7	2	4	8	3	9	2	5	10	11	2	3	4	6	12	13	2	7	14	3	5	15	2	4	8	16	17	2	3	6	9	18	19	2	4	5	10	20	3	7	21	2	11	22	23	2	3	4	6	8	12	24	5	25	2	13	26	3	9	27	2	4	7	14	28	29	2	3	5	6	10	15	30	31	2	4	8	16	32	3	11	33	2	17	34	5	7	35	2	3	4	6	9	12	18	36	37	2	19	38	3	13	39	2	4	5	8	10	20	40	41	2	3	6	7	14	21	42	43	2	4	11	22	44	3	5	9	15	45	2	23	46	47	2	3	4	6	8	12	16	24	48	7	49	2	5	10	25	50	3	17	51	2	4	13	26	52	53	2	3	6	9	18	27	54	5	11	55	2	4	7	8	14	28	56	3	19	57	2	29	58	59	2	3	4,...
	5	6	10	12	15	20	30	60	61	2	31	62	3	7	9	21	63	2	4	8	16	32	64	5	13	65	2	3	6	11	22	33	66	67	2	4	17	34	68	3	23	69	2	5	7	10	14	35	70	71	2	3	4	6	8	9	12	18	24	36	72	73	2	37	74	3	5	15	25	75	2	4	19	38	76	7	11	77	2	3	6	13	26	39	78	79	2	4	5	8	10	16	20	40	80	3	9	27	81	2	41	82	83	2	3	4	6	7	12	14	21	28	42	84	5	17	85	2	43	86	3	29	87	2	4	8	11	22	44	88	89	2	3	5	6	9	10	15	18	30	45	90	7	13	91	2	4	23	46	92	3	31	93	2	47	94	5	19	95	2	3	4	6	8	12	16	24	32	48	96	97	2	7	14	49	98	3	9	11	33	99	2	4	5	10	20	25	50	100];

% 1 fold
F1=	[1	0	2	4	5	1	1	6	2	7	0	2	7	4	1	1	3	2	2	5	0	4	8	1	1	6	1	1	5	2	7	0	1	2	6	14	5	1	2	4	7	12	0	3	9	0	8	6	14	1	2	3	1	4	9	20	3	7	0	8	16	0	5	19	1	2	2	11	24	25	0	2	1	2	6	10	26	9	1	1	3	11	28	2	7	29	0	12	30	0	1	31	1	1	2	1	4	8	13	32	16	0	14	34	0	7	17	1	1	1	2	3	15	36	18	0	0	2	1	8	16	26	19	1	2	4	17	40	0	2	3	9	20	0	18	42	21	1	1	3	1	3	5	10	19	14	2	22	0	3	4	20	44	2	11	23	1	2	6	21	46	24	0	0	2	2	12	22	34	2	3	25	1	3	3	2	7	23	50	0	13	26	0	24	52	27	1	0	2,...
	4	1	3	4	8	14	25	38	28	0	26	56	0	0	1	15	19	1	1	1	9	27	58	0	5	59	0	2	4	2	16	28	60	61	1	2	10	27	62	1	17	63	0	3	5	2	6	28	64	65	1	1	3	5	2	1	5	11	18	29	66	33	0	30	68	2	2	7	17	34	1	2	12	31	70	6	5	71	0	0	4	4	18	32	72	36	1	3	0	1	3	8	11	33	74	0	2	19	37	0	34	76	38	1	0	2	5	4	4	5	12	20	35	78	2	9	39	0	36	80	0	21	40	1	1	2	4	13	37	82	41	0	0	3	4	5	4	7	8	22	38	84	4	6	42	1	2	14	39	28	2	23	43	0	40	60	4	11	44	1	0	1	3	1	5	7	15	24	41	88	45	0	0	6	42	30	1	3	2	25	46	1	2	0	1	6	16	43	92];
I1= [43.6	52.2	45.2	53.6	56	48.3	45.2	61.6	56.9	67.2	47.7	57.3	47.9	53.8	46.5	50.8	59.6	49	48.5	58.5	46.5	55.4	52.7	54.5	53.4	65.4	45.9	61.6	57.2	51.6	55.7	46	60.8	56.7	62.9	54.3	57.5	45.6	51.8	64.7	56.8	69.8	58.8	61.3	62.4	45.7	58.7	58.4	58.8	45.3	55.2	57.3	58.4	67.6	61.4	74.8	56.4	61.2	45.5	58.2	59.7	89.3	60	59	45.3	54.7	59.1	58.6	76.5	75.1	45.4	90.9	60.4	72.5	60.7	74.3	76.1	61	45.2	54.4	60.3	70.4	76.9	89.1	62.4	76.8	45.2	65.8	79.7	90	61.4	75	45.2	88.9	54.8	61.3	64	65.5	66.8	77.1	67.5	45.2	68.2	76.2	90	64.2	67	45.2	54.7	90.6	61.4	61.8	73.4	79.2	66	45.2	90.2	61.1	66.3	66.6	66.2	64.3	70.3	45.2	54.2	62.9	66.7	76.4	90	88.6	63.4	66.4	73.4	45.2	66.9	75.9	68.9	45.1	88.1	55.1	63.4	72	64.4	66.5	69.1	66.5	64.1	66.8	45.2	89.4	63.2	72.9	81.6	89	69.9	67.3	45.1	54.7	69.6	69.9	80.3	71.3	45.1	90.1	62	63.1	74.1	67.6	67.4	89.1	64.7	72.4	45.1	55	89.9	75	79.9	68.4	81.3	89.6	68.5	69	45.1	70.6	79.5	69.3	45.1	89.5	54.8,...
	90	63.3	67.4	67.3	67.9	68.5	72.4	68.2	68.9	45.1	71.1	79.7	89.1	90.2	66	69.3	69.1	45.1	54.9	67.5	67.7	69.3	79.2	89.7	66.6	80.8	45.1	90.2	62.8	65.5	68.9	69.5	81	79.8	45.1	54.7	68.4	72.9	78.1	90.4	70.8	81.6	45.1	89.5	88.9	75.5	67.4	77.9	80.3	80.9	45.1	89.1	54.8	64.1	66.9	68.8	69.6	68.7	73.4	75.1	81.6	74.5	45.1	72.2	79.8	89.8	89.8	84.6	70.8	74.7	45.1	54.7	69.1	76.1	79.7	88.8	87.2	79.6	45.1	89.4	63.2	67.5	70.2	74	79	73.3	45	54.9	90	68.8	74	79.8	69.3	72.5	80.2	90	68.6	70.5	76.2	45.1	76.2	81.2	72.9	45	89.5	54.8	63.9	89.7	68.9	68.8	70.3	72.5	77.5	81.5	89.3	69.6	72.6	45.1	72.2	81.5	90	71.3	72.4	45	54.8	68.1	69	71.4	72.5	81	75	45.1	89.5	89.5	63.3	89.4	77.4	88.4	69.7	71.6	74.1	80.5	89.9	89.8	77.5	45	54.7	71	74.5	73.2	90.1	74.7	74.8	45	73.5	72.2	89.9	69.8	73	45	90	54.8	63.6	69.2	80.4	71.8	71.8	77.6	75.9	82.1	75.4	45	89.4	70.1	77.3	73.2	90	90.1	71.1	73.3	72.9	45	54.8	89.4	71.2	70.7	71.7	74.6	81.8];
Theta1= [69.106	66.729	89.787	66.275	60.009	56.826	57.646	56.4	60.376	54.677	53.246	52.172	51.463	47.493	50.326	47.829	60	49.193	49.574	43.669	49.159	41.782	44.151	42.053	42.631	42.643	47.906	45.968	40.062	43.626	38.674	47.51	41.509	38.263	39.606	40.261	37.008	46.923	41.701	45.316	36.506	40.761	39.76	36.493	37.166	46.707	35.7	35.2	34.618	46.342	37.923	38.898	35.625	36.805	35.792	35.817	37.957	34.194	46.149	34.383	33.018	34.942	32.541	33.166	45.907	37.371	32.867	34.023	32.892	32.307	45.909	34.254	32.637	36.381	31.459	33.518	31.562	31.106	45.764	37.01	31.316	31.194	30.807	33.542	30.824	30.136	45.729	29.731	29.843	30.606	31.745	29.464	45.573	32.971	36.499	31.102	30.944	31.241	28.752	29.083	28.199	45.582	27.918	28.48	32.332	28.362	27.219	45.408	36.172	28.253	29.868	29.779	27.738	28.215	26.546	45.404	32.123	30.037	30.809	27.375	26.319	26.926	26.259	45.345	36.613	28.069	25.648	27.051	31.908	26.352	29.001	26.319	26.178	45.332	24.907	26.543	24.867	45.302	31.648	36.046	28.127	30.116	26.626	25.046	24.485	25.159	27.12	24.138	45.312	25.029	27.681	24.671	25.684	31.356	24.805	23.763	45.23	35.947	26.504	23.752	25.01	23.801	45.258	31.185	28.737	27.497	25.163	23.352	23.453	23.803	25.936	23.77	45.19	35.787	25.491	26.917	27.066	23.052	23.817	31.202	23.151	22.939	45.236	22.978	23.347	22.695	45.178	31.128	35.732,...
    	23.073	27.786	26.545	25.528	23.887	22.557	22.97	22.58	22.316	45.173	22.393	22.314	30.88	23.267	25.943	22.302	22.173	45.163	35.511	24.194	22.866	21.964	22.115	22.275	23.91	21.802	45.165	30.897	27.701	24.989	21.778	21.866	21.66	21.379	45.161	35.71	22.304	21.706	21.51	30.656	21.677	21.062	45.157	21.839	21.764	25.696	23.188	21.618	21.091	20.741	45.154	30.745	35.625	27.525	23.606	23.231	23.901	21.792	22.237	20.857	20.806	20.579	45.151	20.528	20.335	30.593	21.26	22.643	20.893	20.275	45.144	35.578	21.294	20.202	20.264	20.407	24.227	20.023	45.146	30.539	27.13	23.284	20.312	19.828	19.904	19.618	45.135	35.464	20.831	22.46	22.791	22.678	21.103	19.488	19.762	30.595	21.741	19.877	19.604	45.142	19.455	19.596	19.157	45.139	30.567	35.518	27.238	19.465	22.961	21.671	20.731	19.662	19.433	19.41	20.638	21.682	18.959	45.138	18.879	19.201	30.507	19.107	18.767	45.121	35.436	22.315	22.7	20.203	18.575	19.03	18.514	45.135	30.491	20.371	27.065	20.345	21.593	20.901	20.917	18.817	18.353	18.836	18.522	21.4	18.517	45.091	35.495	19.501	18.043	18.717	30.322	18.771	17.978	45.11	17.904	18.194	20.033	20.52	17.749	45.084	30.327	35.347	26.997	21.778	22.484	20.252	19.065	19.402	17.778	18.419	17.656	45.101	17.858	20.523	17.996	17.904	30.302	18.776	20.495	17.839	17.457	45.08	35.37	19.846	20.122	20.318	18.609	17.429	17.947];

% 2 fold
F2=	[2	1	1	4	2	0	1	2	2	2	1	2	2	9	0	1	3	2	10	3	1	2	10	1	4	11	0	2	3	6	3	1	0	2	6	14	11	0	2	1	7	3	0	2	4	1	3	4	18	0	2	2	1	3	3	19	3	11	1	7	4	1	3	12	0	2	1	4	23	16	1	0	3	1	3	4	21	25	0	1	1	9	13	1	4	23	1	10	19	3	1	29	0	1	3	1	3	4	5	29	10	1	13	23	1	5	22	0	3	3	1	3	4	28	11	1	0	4	1	10	5	5	36	0	3	3	15	6	0	3	2	8	6	1	16	19	17	0	2	2	4	1	4	9	5	7	1	30	1	1	2	17	43	2	5	43	0	2	5	18	32	41	1	0	4	2	10	19	20	1	3	34	0	1	1	1	5	20	12	1	11	49	1	20	50	51	0	1	3,...
	0	4	3	4	6	6	21	26	13	1	22	48	0	5	1	12	8	0	3	1	6	12	55	0	4	14	1	2	4	3	13	19	51	37	0	3	7	24	42	0	7	30	0	3	5	2	5	13	54	31	0	0	2	3	1	1	3	7	14	21	21	64	0	14	65	2	1	5	15	58	0	1	8	14	33	5	2	36	0	1	3	4	8	23	34	23	0	1	0	1	2	6	11	15	9	1	1	16	71	1	24	24	73	1	2	3	2	5	3	5	12	17	8	74	2	7	25	1	33	60	1	9	38	0	3	7	2	13	34	10	26	1	0	2	1	1	1	5	7	21	17	65	5	4	74	1	3	13	27	82	1	7	83	0	36	34	3	8	28	0	0	2	1	6	3	6	14	22	37	17	70	0	4	4	38	10	0	1	2	23	10	0	1	3	2	8	7	19	63];
I2=	[2.8	58.8	43.2	45.2	61.2	55.8	49.5	53.6	62	61.3	46	55.2	60.6	59	45.6	57	58.7	54	54.5	52.7	45.9	57.5	53.6	55.3	60.5	58.5	45.5	52.3	51.9	52.2	55.1	45.8	56.9	51.1	55.1	53.5	54.4	45.4	54.5	63.6	60.1	53.8	55.1	59.6	56.8	45.5	54.7	54.7	54.5	45.3	55.4	55.2	59.6	54.9	57.4	59	55	57.2	45.3	60.7	56.3	54.5	57.9	57.6	45.2	55.1	57.1	56.7	55.8	57.9	45.3	55.5	57.3	61.5	57.4	59.1	58.3	60.4	45.3	56.5	57	61.6	58.8	89.2	59.5	59.1	45.2	58.3	60	58.3	57.4	61.9	45.2	91.4	54.6	59.3	59	59.8	59.4	62.4	60.1	45.1	59.1	59.6	90.2	59.9	60.1	45.1	54.9	58.8	57.1	60.6	60.8	61.6	60.7	45.2	54.9	60.2	60.7	60	61	60.1	61.4	45.2	54.9	61.6	61.4	61	88.2	59.1	59.6	61	60.7	45.1	63.4	61.9	61.2	45.1	89.7	55.1	61.3	61.6	63.5	62.1	61.5	63.3	62.4	62.9	45.1	58.8	61	62.9	62.9	90.9	61.9	62.7	45.1	55	63.7	63.5	64.2	62.6	45.2	54.7	61.9	62.8	63.4	63.7	63.2	59.2	62.8	64.2	45.1	55.3	63.7	64.6	63.6	65.4	64.6	89.2	64.3	64.5	45.2	64.2	64.8	64.4	45.1	90.2	54.7,...
	87.8	62.3	64.2	64.7	64.9	64.2	65.2	64.6	64.6	45.1	66.2	65.4	88.5	64.2	65.2	65.7	71.1	45.1	54.8	65.6	65.5	65.3	66.1	90.7	64.9	65.4	45	90.2	62.4	63	66	64.9	65.5	65.6	45	54.8	67.2	65.2	65.8	88.6	65.7	66.7	45	88.9	64.5	65.1	66.1	66.4	66.8	66	45.1	89.6	55	63	66.2	67.2	64.9	64.9	66.2	66.3	66.7	66.9	45.1	66.2	66.7	90.7	89.6	68	68.1	66.7	45.1	55	67.7	66.7	67.4	65	65.3	66.7	45.1	89.6	63	65.7	66.9	66.8	66.9	67.8	45.1	55	88.6	66.9	70.2	68.1	66	68.6	69.9	89.4	68.2	67.4	67.9	45.1	67.8	67.6	68.1	45.1	89.9	54.7	63.1	65.4	66.3	66.6	67.3	67.2	67.6	68.8	89.2	68.4	71.9	45.1	68.8	67.8	89.7	67.5	68	45.1	54.8	69	67.6	67.3	69.2	69.2	68.6	45.1	88.7	89.9	63	68.6	69	69	68.1	68	68.6	69.7	65.6	65.7	68.2	45.1	54.8	68.3	68.8	68.6	89.4	68.6	69.9	45.1	69	68.6	90.1	68.9	68.8	45.1	90.2	54.9	63.1	67.3	68.7	69.2	68.5	68.3	69.2	69	69.2	45.1	65.9	67.1	69.4	70.4	89.6	69.2	69.8	69	69.8	45.1	54.8	89	69.8	69.3	68.8	71.8	69.5];
Theta2=	[89.936	89.85	89.94	89.787	75.839	89.8	89.778	71.376	66.055	69.215	73.011	65.351	64.089	62.375	63.6	56.561	61.198	56.501	59.305	54.644	58.442	54.844	52.157	51.243	60.053	51.374	55.043	49.735	50.272	50.391	47.624	53.046	50.047	50.039	48.526	46.634	45.569	51.306	44.048	47.262	47.141	45.866	48.674	44.92	43.989	50.235	43.306	42.528	42.233	49.3	45.717	41.134	45.207	42.066	41.279	41.926	40.924	40.856	48.716	40.348	39.336	42.886	38.95	39.593	48.184	39.779	40.007	38.252	39.145	38.61	47.826	41.837	37.288	38.186	37.435	37.678	37.681	36.653	47.322	39.2	37.452	37.055	36.012	39.125	36.281	35.74	47.177	35.506	35.486	35.238	36.459	36.117	46.808	37.749	38.168	34.619	35.471	35.719	35.483	34.864	33.727	46.693	33.971	33.919	36.65	34.532	32.978	46.535	37.353	34.047	36	32.936	33.881	33.219	32.616	46.36	38.279	32.43	32.17	33.299	33.112	32.544	31.444	46.21	37.005	31.558	31.366	31.456	35.004	33.307	33.265	31.887	32.067	46.128	30.976	30.865	31.113	46.08	34.331	36.848	30.793	30.977	30.238	30.813	30.873	30.668	29.918	29.792	45.928	32.774	31.295	29.768	29.63	33.904	30.005	29.757	45.856	36.657	29.208	28.957	29.2	29.514	45.743	37.105	29.788	30.335	28.807	28.557	28.649	32.12	29.351	28.915	45.716	36.53	28.55	28.097	28.231	28.667	28.321	33.11	27.981	27.818	45.719	27.853	27.668	27.893	45.609	32.734	36.28,...
    	30.857	29.117	30.06	27.962	27.59	27.249	27.345	27.302	26.97	45.61	27.119	27.09	32.46	27.469	27.136	26.708	27.148	45.602	36.024	26.425	27.114	27.025	26.644	29.1	26.497	26.193	45.592	32.318	28.716	28.646	26.014	26.365	26.143	25.882	45.553	35.974	26.579	26.111	26.448	32.116	25.527	25.554	45.515	27.6	26.562	26.334	25.491	25.482	25.614	25.403	45.476	31.89	35.959	28.403	25.294	25.083	27.047	26.114	25.113	25.116	25.223	24.98	45.411	24.844	24.603	31.769	26.448	24.863	24.791	24.803	45.387	35.925	25.791	24.509	24.481	25.938	25.906	24.866	45.33	31.542	28.111	25.339	24.35	24.221	24.191	24.15	45.311	35.881	25.463	24.559	24.148	23.949	25.093	23.943	23.96	31.479	23.725	24.006	23.882	45.28	23.649	23.474	23.447	45.26	31.307	35.772	27.9	25.459	25.72	24.219	24.337	23.674	23.388	23.552	24.61	23.274	23.404	45.252	23.082	23.078	31.23	23.462	23.264	45.245	35.672	24.015	23.396	23.529	22.899	23.083	22.796	45.239	31.192	23.926	27.733	22.783	22.579	23.239	22.682	23.38	22.656	22.745	25.145	24.989	22.636	45.233	35.669	22.883	22.468	22.264	31.123	22.961	22.311	45.219	22.129	22.126	23.318	22.281	22.168	45.222	31.018	35.656	27.559	23.373	22.859	22.223	22.273	22.467	21.875	21.836	21.817	45.21	24.932	23.605	21.817	21.833	30.983	22.115	21.673	22.001	21.568	45.213	35.625	22.808	21.496	21.864	21.865	21.92	21.492];
% 3 fold
F3=	[2	0	0	0	3	1	3	4	2	3	1	2	8	3	1	2	2	3	10	4	0	4	4	1	4	6	1	2	3	14	15	0	2	5	4	4	14	1	2	3	4	12	2	3	5	0	7	16	14	1	2	2	4	4	5	14	4	9	0	10	6	1	5	16	1	0	5	11	8	13	0	0	3	4	4	12	26	6	1	3	3	13	28	0	2	15	0	14	20	4	5	16	1	2	0	2	4	8	15	32	17	0	16	30	1	3	18	1	3	3	6	5	17	6	19	0	0	2	5	6	18	8	20	1	0	6	19	28	1	4	1	7	21	0	20	14	22	1	0	3	1	3	7	6	21	4	3	11	0	0	4	10	32	2	13	41	1	0	8	23	16	12	0	2	0	5	14	11	4	3	5	17	1	1	3	6	9	25	36	1	15	23	0	12	18	38	0	0	2,...
	4	1	1	6	2	16	27	18	19	0	28	40	0	2	4	17	40	1	1	5	7	29	20	2	7	42	0	2	0	5	16	14	20	56	1	0	8	21	44	1	17	21	0	0	1	6	8	26	22	46	0	0	3	1	4	4	1	9	18	27	22	28	0	25	58	1	4	9	21	23	1	2	12	11	14	6	1	48	0	1	0	2	22	16	16	66	1	3	4	3	7	10	13	35	76	2	8	23	59	0	17	78	12	1	2	2	1	2	6	1	10	4	37	80	4	11	62	0	18	82	0	19	20	1	1	2	0	15	39	84	65	0	0	3	0	3	8	8	8	20	19	86	0	1	21	1	0	16	41	88	2	16	68	0	20	90	3	3	22	1	1	1	1	3	7	9	17	20	43	60	71	1	3	2	21	94	1	0	10	18	47	0	2	1	7	12	18	45	96];
I3=	[0.4	0.4	0.4	0.4	2.8	3.2	2.8	0.4	76.2	58.8	49.2	64.1	56	59.8	58.8	46	59.9	54.4	53.4	49.6	45.4	54.9	47.3	52.2	59	57.1	45.2	51	52.1	56.3	50.1	45.5	49.6	59.9	57.5	51.6	53.9	45.2	52.7	51.7	51.5	52.5	54.6	56.2	55.2	45.4	55.8	52.3	55.3	45.3	54	53.2	50.2	54.2	51.7	52.4	50.8	53.6	45.3	55	51.4	55.1	56.6	53.3	45.1	60.5	51	57.4	56.8	56.1	45.3	55.5	52	51.2	52.1	56.3	61.8	56.3	45.2	53.8	56.8	56.6	53.7	54.9	58.6	56.9	45.2	58.6	53.1	52.3	53.3	57.7	45.2	55.1	54.4	51.2	55.4	53	58.1	54.7	58.8	45.2	57.8	53.8	54.8	54.3	58	45.2	55.2	53.6	52.4	56.1	59.4	54.3	57.9	45.1	54.9	53.7	54.6	54.7	58.3	54.7	59	45.2	54.7	58.7	58.7	55.9	55.3	55.7	59.1	60.7	58.6	45.1	59.1	56.5	58.4	45.2	54.9	55.2	55.8	57.3	58.9	57.4	58.5	56.6	55.7	59.5	45.1	57.1	56.4	59.1	57.7	55	58.1	58.4	45.1	54	62.8	59.1	58.2	62	45.2	90.9	56.7	57.7	58.6	62.6	61.2	59	57	58.9	45.1	54.6	56.4	55.9	65.8	58.8	59	55	60	59.1	45.1	64.9	59.3	59.6	45.1	54.7	54.9,...
	58.9	61.5	59.2	59.6	58.9	59.7	59.2	60.3	60.6	45.1	58.9	60	90	57.7	59.3	60.2	59.5	45.1	55.1	57.6	58.8	59	60.3	60.7	60	62	45.1	88.2	60.5	59.2	61	69	60.8	61.2	45.1	54.9	61.8	60.9	60.9	55	65.2	62.6	45.1	60.8	57.8	59.2	60.9	69.1	60.7	61.1	45	54.7	55	60.9	58.6	59.4	66	67.1	68.8	79.2	66	60.8	45.1	61.5	61.6	54.8	60.1	61.7	61.4	70.8	45.1	54.6	61.1	64.1	61.8	59.2	61	66.7	45.1	91.5	61.9	61.6	61.3	62.4	61.6	64.2	45.1	55.1	60.2	59.2	60.2	62.2	61.9	64.2	73.2	88.9	82.5	62	61.9	45.1	62.4	75	63	45.1	55	54.9	62.3	63.1	64	66.3	65.7	62.1	62.9	74.5	60.1	62.9	63.6	45.1	63.9	75	90.2	66.4	63.1	45.1	54.9	60.2	88.7	63.3	64.6	76	63.9	45.1	54.8	87.5	62.5	60.3	60.8	61.6	61.6	73.3	63.6	73.6	65.8	64.4	65.4	45.1	54.7	66	64.8	75	89.1	64	64.9	45.1	64.3	74.3	89.7	66.7	65.4	45	89.4	54.7	62.4	64.9	63.4	66.5	64.1	62.8	66.4	76.4	65.4	45	64.1	63.6	66.3	75.1	89.3	90	83.4	65.2	64.6	45	54.6	90	62	63.6	65	65.9	76.1];
Theta3=	[108.001	90.4	90	90.4	89.953	89.993	89.921	90	89.85	82.992	89.825	89.796	80.02	74.462	89.8	78.135	70.811	72.41	71.763	67.847	77.455	66.995	65.998	69.7	63.544	63.104	69.097	63.599	62.673	61.622	60.285	63.544	60.584	60.708	57.814	57.577	56.973	59.65	57.265	53.485	53.794	54.975	53.063	55.582	51.72	56.945	52.578	50.601	51.19	54.808	50.075	53.958	50.119	49.523	49.108	50.263	50.588	49.515	53.367	48.63	48.221	46.989	47.362	46.956	52.086	51.337	47.665	47.371	46.349	45.655	51.241	46.854	46.602	46.229	46.712	44.994	47.052	43.803	50.277	45.693	46.891	43.514	44.277	46.477	44.206	42.852	49.7	42.644	43.119	43.927	42.464	41.622	49.2	45.303	42.404	44.605	42.884	43.793	41.08	42.114	40.805	48.702	40.051	41.251	43.622	41.903	39.606	48.298	41.627	42.273	42.043	40.212	39.539	40.831	38.812	48.024	42.296	41.217	40.073	39.71	38.483	39.864	38.239	47.702	40.214	38.436	37.768	39.324	41.308	40.217	38.728	38.099	37.477	47.516	37.323	38.387	36.883	47.237	40.303	39.804	39.588	38.898	36.503	37.39	36.74	37.813	38.763	36.298	47.1	37.31	38.09	36.222	36.642	39.727	36.312	35.71	46.944	39.354	36.165	35.905	35.973	35.552	46.747	37.235	38.156	36.402	35.259	35.498	36.205	35.207	35.72	35.02	46.635	38.742	37.05	36.93	36.015	35.126	34.719	38.773	34.731	34.191	46.6	34.834	34.089	33.864	46.47	38.377	38.171,...
    	33.907	36.1	33.47	34.94	34.82	33.631	34.679	34.36	33.676	46.269	34.348	33.109	35.295	35.544	34.353	32.983	32.856	46.215	37.412	35.351	33.49	34.283	32.72	32.946	33.184	33.018	46.151	34.827	33.421	32.993	31.943	34.071	32.066	31.922	46.102	37.274	32.276	33.716	32.001	37.561	31.539	31.445	46.1	32.309	34.362	32.649	31.922	32.857	31.701	31.548	46.048	37.479	37.387	32.244	33.914	33.274	31.499	31.721	31.403	32.303	31.29	30.973	45.949	31.08	31.001	37.226	31.824	30.928	31.003	30.976	45.881	37.23	30.983	31.558	30.719	32.919	31.087	30.32	45.773	33.482	30.971	31.169	30.647	30.673	30.452	29.926	45.731	36.933	31.497	32.781	31.925	30.096	29.889	30.886	30.066	33.214	31.843	30.514	29.801	45.666	29.571	29.732	29.149	45.656	36.855	36.537	30.317	30.693	30.127	30.809	29.125	29.787	29.841	29.443	31.458	29.586	29.06	45.625	28.796	29.035	32.702	29.118	28.53	45.617	36.443	32.182	29.288	28.126	28.8	28.79	28.018	45.609	36.586	30.511	29.829	30.847	30.437	29.632	29.72	28.805	27.948	28.54	29.459	27.774	27.991	45.607	36.387	27.805	27.899	28.235	32.396	28.5	27.429	45.602	27.139	27.958	29.254	28.691	27.137	45.565	32.244	36.422	29.405	30	28.127	29.078	27.472	28.979	27.249	27.648	26.768	45.547	28.224	27.823	26.785	27.551	32.087	30.007	28.111	28.13	26.722	45.523	36.344	28.114	29.45	27.936	27	26.562	27.314];

% 4 fold
F4=	[3	0	2	3	3	0	0	3	2	4	1	2	8	4	0	2	1	2	2	2	1	4	2	1	4	2	0	0	5	10	11	0	1	5	5	2	5	0	3	4	7	8	2	6	5	1	5	16	17	0	2	2	4	4	5	20	4	6	1	6	6	2	5	20	0	3	5	6	24	25	1	2	4	4	6	7	7	3	0	0	6	11	28	0	6	29	1	6	20	0	5	22	0	1	1	0	2	8	10	14	7	1	7	30	1	9	23	1	1	1	6	5	3	15	36	1	1	5	2	8	16	8	23	0	1	5	17	26	0	0	3	5	40	1	6	41	7	0	2	0	5	4	6	7	3	39	2	23	1	0	5	15	45	2	6	9	1	0	7	7	8	25	1	1	1	3	8	24	39	2	5	45	1	3	2	3	8	8	9	1	7	33	1	9	26	33	0	0	1,...
	2	0	8	7	9	9	18	41	8	1	19	56	1	1	5	8	5	0	1	3	11	26	45	2	1	41	1	0	5	5	10	27	37	9	0	1	12	21	62	0	3	14	0	2	2	6	1	19	48	50	0	2	1	0	3	4	6	13	17	22	11	41	1	20	10	1	1	1	13	10	0	0	7	31	21	2	7	20	0	0	5	6	19	21	61	72	1	2	2	2	5	9	3	27	22	2	3	4	21	0	11	30	38	0	2	1	3	0	8	8	3	4	23	71	4	10	71	1	29	79	1	15	80	0	1	3	7	8	12	23	27	1	0	2	5	2	5	1	3	11	10	33	0	6	77	0	1	4	31	78	0	16	75	0	16	87	3	3	35	1	1	0	3	2	8	2	9	17	11	44	45	1	6	7	30	79	1	3	7	17	84	1	0	2	5	3	10	36	12];
I4=	[51.8	0.5	0.4	0.4	0.4	0.4	0.4	0.4	0.4	12.8	2.8	40.6	66.9	68	2.8	43.4	30.4	45.2	58.6	45.6	87.8	61.9	62	54.6	67.2	53.7	55.8	41.5	59.2	58	53.3	44.9	56.7	61.8	50.8	60.1	57.9	45	56	58.3	59.5	55.4	54.4	61.6	60.1	45.2	55.2	57.5	56.7	45.2	54.3	59.6	54.6	56.9	55.4	56	55.4	54.3	45.3	55	54	54.7	53.2	56.7	45	57.7	52.8	52.9	55.6	54.5	45.2	54.7	50.5	54.1	53.3	56.4	52.4	52.8	45.2	53.7	52	54.4	54.6	54.5	54.9	53.8	45.1	55	53.9	56.2	53.8	54.1	45.1	54.2	54.7	53.5	52.5	55.9	53.6	53.7	53.9	45.2	53.8	53.6	54.8	57.1	54.1	45	55	52.4	53.9	54.1	53.8	55.7	55.5	45.1	54.6	52.8	53.8	54	55.4	54.1	54.8	45.1	55	56.7	55.8	54.1	54.8	55.4	55.5	56.6	56.6	45.1	56.9	56.1	55	45.1	55.4	55.4	52.9	56.8	57.4	55.2	55.3	55.5	55.5	57.7	45.2	56.6	56.8	56.6	56.9	54.6	57.7	56.1	45	55.2	58.4	56.1	57.3	58.2	45.2	55.1	56.4	56.2	56.2	58.6	57.8	57.1	58	57.2	45	55.3	56.8	56.3	56.7	57.4	56.6	55.1	57.1	56.9	45.1	56.8	57.3	57	45.1	54.8	54.6,...
	58	57.8	56.9	56.1	57.1	57.1	58.9	57.6	57.5	45	57.7	57.8	54.7	57.1	58.6	58.1	58.2	45.1	54.7	56.5	58.2	58.1	57.8	58.2	58.1	57.8	45.1	55	59.8	59.8	57.8	58.7	58.4	59.4	45	54.7	59.1	59.7	58.7	54.8	58.6	59.2	45.1	58.4	56.8	59.6	58.8	59	59	59.3	45.1	55	54.7	60.9	56.4	59.4	60.6	61.4	58.8	59	60.6	60.3	45.1	59.6	60	55.1	58.8	59.7	59	59.7	45.1	55	58.9	60	59.8	59	60	60	45	54.9	61.2	60.2	61.1	59.9	59.8	60.2	45	54.9	59.3	56.6	60.1	60.5	60.1	60.8	60.6	55	58.9	60.2	60.3	45.1	60	60.4	60.5	45.1	54.9	54.8	60.9	61.1	60.1	62.4	60.5	60.6	60.4	61.6	60.5	60.5	61.1	45.1	61.3	61.3	55	61.5	61	45.1	54.8	59.1	61.3	61.3	61.2	61	60.7	45.1	55	61.3	62	59.6	60.7	61.1	61.4	61.2	61.6	61.3	62.2	63.2	62.2	45	54.8	61.6	62.4	61.9	89.4	62.2	61.8	45	62.3	61.7	60.8	62.5	62.2	45	55.1	54.9	61.5	61.4	61.8	63.2	62.2	62.9	62.2	62.1	61.8	45	62.2	63	62.1	62.6	54.8	59.3	62	62.9	62.3	45	54.9	60.5	60.9	62.4	63.7	62.6	62.2];
Theta4=	[138.921	120	120.001	120	102.858	90	90	90.128	90.133	89.99	89.927	89.974	89.846	85.172	89.879	89.85	85.536	89.787	82.359	77.018	89.805	75.688	75.629	72.962	71.664	71.271	89.8	72.75	70.861	69.133	67.038	80.15	64.098	65.312	66.258	66.02	62.908	72.812	65	62.559	61.876	62.042	58.68	61.667	61.424	67.483	59.26	57.918	56.733	63.469	54.971	60	55.113	57.531	54.814	55.166	56.452	54.41	60.442	52.533	52.459	52.382	52.799	52.371	58.065	53.075	51.016	50.937	50.826	50.295	56.218	50.864	54.951	50.666	50.521	50.192	49.695	49.014	54.703	48.857	48.838	48.525	48.158	49.122	48.198	47.533	53.592	47.645	47.061	51.528	46.46	46.326	52.6	46.881	45.9	48.091	47.111	46.261	46.57	45.94	45.195	51.735	45.077	44.898	45.849	44.964	44.224	51.091	43.58	45.804	43.814	45.148	44.036	43.727	43.286	50.424	45.935	45.647	43.246	43.349	42.917	42.921	42.679	49.947	42.047	43.088	42.251	42.34	45.834	42.412	41.802	41.815	41.591	49.511	41.521	41.179	40.833	49.1	45.157	41.152	44.043	40.954	41.279	40.945	40.574	40.435	41.36	40.488	48.75	40.067	39.899	39.775	39.871	43.809	39.513	39.428	48.519	40.388	39.506	38.962	39.253	39.172	48.202	42.766	40.474	38.55	38.556	38.875	38.783	38.521	38.885	38.464	48.03	39.64	39.813	38.411	38.229	37.978	37.994	41.811	37.384	37.676	47.708	37.357	37.169	37.164	47.6	41.097	38.973,...
    	37.047	37.526	37.05	37.723	37.268	36.918	36.986	36.847	36.726	47.416	36.194	36.223	40.563	38.839	36.331	36.17	36.172	47.201	38.412	36.935	36.31	35.804	35.748	35.929	35.984	35.848	47.142	40.066	35.604	35.421	35.671	35.521	35.316	35.202	47.032	38.056	35.086	35.152	34.846	39.628	35.099	34.618	46.874	35.056	36.413	34.552	34.635	34.641	34.767	34.147	46.739	39.2	37.845	34.085	36.4	34.845	33.985	34.691	34.213	34.406	34.094	33.946	46.604	33.688	33.685	38.857	34.452	33.68	33.815	33.689	46.602	37.616	33.851	33.18	33.198	33.973	33.237	33.165	46.529	38.621	32.946	33.114	33.078	32.888	32.81	32.684	46.43	37.353	33.741	36	32.828	32.696	32.838	32.52	32.452	38.323	33.573	32.372	32.363	46.336	32.459	32.521	31.883	46.247	38.117	37.184	32.085	32.26	32.04	32.243	31.996	32.05	32.054	31.877	32.824	31.758	31.68	46.121	31.459	31.384	37.861	31.283	31.299	46.108	36.888	32.991	31.311	31.348	31.264	31.234	31.388	46.106	37.749	32.314	31.364	33.117	31.831	31.499	30.908	30.94	30.882	30.914	30.847	30.887	30.796	46.091	36.804	30.564	30.607	30.546	34.248	30.456	30.378	46.041	30.351	30.335	31.571	30.135	30.194	46.009	37.422	36.717	30.634	30.887	29.988	30.839	29.951	30.076	30.158	30.011	30.159	45.946	29.694	29.696	29.76	29.722	37.226	32.56	30.099	29.721	29.663	45.912	36.602	31.336	31.24	29.653	29.581	29.569	29.444];

if diversity >= 1 & diversity < 2
    for i = 1:length(Theta1)
        if theta > Theta1(i)
            break;
        end;
    end;
    Tmin1 = T(i);
    Pmin1 = ceil(Tmin1/6);
    Fmin1 = F1(i);
    Imin1 = I1(i);
    
    for i = 1:length(Theta2)
        if theta > Theta2(i)
            break;
        end;
    end;
    Tmin2 = T(i);
    Pmin2 = ceil(Tmin2/6);
    Fmin2 = F2(i);
    Imin2 = I2(i);
    
    Tmin = round(Tmin1 + (diversity - 1)*(Tmin2 - Tmin1));
    Pmin = round(Pmin1 + (diversity - 1)*(Pmin2 - Pmin1));
    Fmin = round(Fmin1 + (diversity - 1)*(Fmin2 - Fmin1));
    Imin = round(Imin1 + (diversity - 1)*(Imin2 - Imin1));    
end;

if diversity >= 2 & diversity < 3
    for i = 1:length(Theta2)
        if theta > Theta2(i)
            break;
        end;
    end;
    Tmin2 = T(i);
    Pmin2 = ceil(Tmin2/6);
    Fmin2 = F2(i);
    Imin2 = I2(i);
    
    for i = 1:length(Theta3)
        if theta > Theta3(i)
            break;
        end;
    end;
    Tmin3 = T(i);
    Pmin3 = ceil(Tmin3/6);
    Fmin3 = F3(i);
    Imin3 = I3(i);
    
    Tmin = round(Tmin2 + (diversity - 2)*(Tmin3 - Tmin2));
    Pmin = round(Pmin2 + (diversity - 2)*(Pmin3 - Pmin2));
    Fmin = round(Fmin2 + (diversity - 2)*(Fmin3 - Fmin2));
    Imin = round(Imin2 + (diversity - 2)*(Imin3 - Imin2));    
end;

if diversity >= 3 & diversity <= 4
    for i = 1:length(Theta3)
        if theta > Theta3(i)
            break;
        end;
    end;
    Tmin3 = T(i);
    Pmin3 = ceil(Tmin3/6);
    Fmin3 = F3(i);
    Imin3 = I3(i);
    
    for i = 1:length(Theta4)
        if theta > Theta4(i)
            break;
        end;
    end;
    Tmin4 = T(i);
    Pmin4 = ceil(Tmin4/6);
    Fmin4 = F4(i);
    Imin4 = I4(i);
    
    Tmin = round(Tmin3 + (diversity - 3)*(Tmin4 - Tmin3));
    Pmin = round(Pmin3 + (diversity - 3)*(Pmin4 - Pmin3));
    Fmin = round(Fmin3 + (diversity - 3)*(Fmin4 - Fmin3));
    Imin = round(Imin3 + (diversity - 3)*(Imin4 - Imin3));    
end;
Imin = Imin*pi/180;